﻿using System;

namespace Microscopic_Traffic_Simulator___Model.Utilities
{
    /// <summary>
    /// TimeSpan helper methods
    /// </summary>
    public static class TimeSpanExtension
    {
        /// <summary>
        /// Multiply TimeSpan instance.
        /// </summary>
        /// <param name="multiplicand">TimeSpan instance as multiplicand.</param>
        /// <param name="multiplier">Multiplier.</param>
        /// <returns>Multiplied TimeSpan instance.</returns>
        public static TimeSpan Multiply(this TimeSpan multiplicand, int multiplier)
        {
            return TimeSpan.FromTicks(multiplicand.Ticks * multiplier);
        }

        /// <summary>
        /// Multiply TimeSpan instance.
        /// </summary>
        /// <param name="multiplicand">TimeSpan instance as multiplicand.</param>
        /// <param name="multiplier">Multiplier.</param>
        /// <returns>Multiplied TimeSpan instance.</returns>
        public static TimeSpan Multiply(this TimeSpan multiplicand, double multiplier)
        {
            return TimeSpan.FromTicks((long)Math.Round(multiplicand.Ticks * multiplier));
        }

        /// <summary>
        /// Divide TimeSpan instance.
        /// </summary>
        /// <param name="dividant">TimeSpan instance as dividand.</param>
        /// <param name="divider">Divider.</param>
        /// <returns>Divided TimeSpan instance.</returns>
        public static TimeSpan Divide(this TimeSpan dividant, int divider)
        {
            return TimeSpan.FromTicks(dividant.Ticks / divider);            
        }

        /// <summary>
        /// Divide TimeSpan instance.
        /// </summary>
        /// <param name="dividant">TimeSpan instance as dividand.</param>
        /// <param name="divider">Divider.</param>
        /// <returns>Divided TimeSpan instance.</returns>
        public static TimeSpan Divide(this TimeSpan dividant, double divider)
        {
            return TimeSpan.FromTicks((long)Math.Round(dividant.Ticks / divider));
        }
    }
}
